/************************************************************************
* \file: trace_control.c
*
* \version: $Id: 
*
* This file implements the basic initialization and uninitialization for
* USB attach and detach.
*
* \component: Gen2 Linux Trace
*
* \author  Eckhard Diezel, ediezel(o)de.adit-jv.com
* \modified: 
* \copyright: (c) 2003 - 2010 ADIT
*
***********************************************************************/


#include <stdio.h>
#include <getopt.h>
#include <string.h>

#include <trace_interface.h>
#include <syslog.h>

/**
* To be called on media attach
*
* \parm None
*
* return None
*/

void TRACE_attach(char *path)
{
	S32 ret;
	ret = TRACE_media_attach(path);
	printf("TRACE_media_attach from trace_control: %d\n", ret);
        syslog(LOG_NOTICE, "TRACE media attached\n");
}

/**
* To be called on media detach
*
* \parm None
*
* return None
*/

void TRACE_detach(void)
{
	S32 ret;
	ret = TRACE_media_detach((TRACE_media_type)0);
	printf("TRACE_media_detach from trace_control: %d\n", ret);
        syslog(LOG_NOTICE, "TRACE media Detached\n");
}

/**
* Entry point for Trace ctrl 
* This routine shall be called for USB attach/detach 
*  signal from udev
*
* \parm  commanline arguments
*
* return \li 0  Normal termination
*/

int main(int argc, char *argv[])
{ 
   	int c = 0;

	while (c != -1)
	{
        int option_index = 0;
        static struct option long_options[] = {
            {"help", 0, 0, 0},
            {"attach", 2, 0, 0},
            {"detach", 0, 0, 0},
            {0, 0, 0, 0}
        };

        if (-1 == (c = getopt_long (argc, argv, "had",
                 long_options, &option_index)))
        {
        	break;
        }

        switch (c)
        {
        case 0:
        	if (0 == strcmp(long_options[option_index].name, "attach"))
        	{
				TRACE_attach(argv[optind]);
        	}
        	else if (0 == strcmp(long_options[option_index].name, "detach"))
        	{
				TRACE_detach();
        	}
        	else if (0 == strcmp(long_options[option_index].name, "help"))
        	{
            	/* ToDo: help() */
        	}

        	break;

        case 'h':
        	/* ToDo: help() */
        	break;

        case 'a':
			TRACE_attach(argv[optind]);
        	break;

        case 'd':
			TRACE_detach();
        	break;

        default:
        	;
        }
	}

   return 0;
}

